<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class UserAddresses extends View {

	public $SingularName = 'آدرس';
	public $PluralName = 'آدرس های کاربران';

	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('نام آدرس'),
																	HtmlTags::Th('آدرس'),
																	HtmlTags::Th('واحد و طبقه'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'user_address_name',
																	'user_address_text',
																	'user_address_floor'
																])
															)
													)
											)
									)
							)
						)
				);
	}

	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}

	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(5) .
										$this->Html()->Label('نام آدرس') .
										$this->Html()->Input('user_address_name') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(7) .
										$this->Html()->Label('آدرس') .
										$this->Html()->Input('user_address_text') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('واحد و طبقه') .
										$this->Html()->Input('user_address_floor') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('کد پستی') .
										$this->Html()->Input('user_address_zip_code') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('شماره تماس') .
										$this->Html()->Input('user_address_phone') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('کاربر') .
										$this->Html()->Select('user_id','user_id',\model\Users::toOption()) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->CardFooter()
									)
							)
						)
				);
	}

	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}

	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

}
        