<?php

namespace model;

use DATABASE\Model;
use fwJson\Json;
use PaymentInterface;

class  PaymentTable extends Model implements PaymentInterface {
	public static array $types = [
		'order' => "Order payment",
	];
	public $_table = 'PaymentTable';
	public $_key = 'payment_id';

	public static function toDataModel($item): array {
		return [
			'gate'        => $item->payment_gate,
			'date'        => date("Y/m/d", strtotime($item->payment_sdate)),
			'hour'        => date("H:i", strtotime($item->payment_sdate)),
			'isSucceeded' => $item->payment_status == 1,
			'amount'      => $item->payment_amount / 10,
			'code'        => $item->payment_resnum,
			'refnum'      => $item->payment_refnum,
		];
	}

	public static function getType($payment_type) {
		return self::$types[$payment_type] ?? "Unknown";
	}

	public function save(int $customer_id, int $total_amount, string $resNum, Json $orderData, string $type) {
		if ($id = $this::add([
			'user_id'            => $customer_id,
			'payment_amount'     => $total_amount,
			$this->ResNumField() => $resNum,
			'payment_date'       => time(),
			'payment_type'       => $type,
			'payment_gate'       => 'Ziina',
			'payment_data'       => $orderData->jsonSerialize(),
			//			'payment_from'       => str("{$_SERVER['HTTP_REFERER']}")->includes('negaclub.ir') ? "site" : "app",
		])) {
			return $id;
		}
		return false;
	}

	public function ResNumField(): string {
		return 'payment_resnum';
	}

	public function RefNumField(): string {
		return 'payment_refnum';
	}

}
