<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Books;
use model\Products;
use model\UserAddresses;

class OrdersEntity extends EntityScheme {
	static $statusList = [
		0  => "Processing",
		1  => "Confirmed",
		2  => "Sent",
		3  => "Delivered",
		4  => "Returned",
		-1 => "Canceled",
	];
	public $order_id;
	/**
	 * انتخاب کاربر
	 **/
	public $user_id;
	/**
	 * انتخاب آدرس
	 **/
	public $user_address_id;
	/**
	 * محصولات
	 **/
	public $book_id;
	/**
	 * هزینه ارسال
	 **/
	public $fee;
	/**
	 * مجموع قیمت محصولات
	 **/
	public $total;
	/**
	 * تخفیف
	 **/
	public $discount;
	/**
	 * مبلغ قابل پرداخت
	 **/
	public $payable;
	public $status;
	public $created_at;

	public static function getStatusStatic($status): string {
		$text = "process";
		switch ($status) {
			case 0:
				$text = "در حال پردازش";
				break;
			case 1:
				$text = "تایید شده";
				break;
			case 2:
				$text = "ارسال شده";
				break;
			case 3:
				$text = "تحویل داده شده";
				break;
			case 4:
				$text = "مرجوع شده";
				break;
			case -1:
				$text = "لغو شده";
				break;
		}
		return $text;
	}

	public function model(): \model\Orders {
		return new \model\Orders();
	}

	public function fullFormat(): array {
		$address = UserAddresses::get($this->user_address_id);
		$orderProducts = json_decode($this->book_id, true);
		$products = Books::Db()->whereIn('book_id', array_keys($orderProducts))->get()->map(function (BooksEntity $productsEntity) use ($orderProducts) {
			$product = $productsEntity->apiFormat();
			$product['count'] = 1;
			if (isset($orderProducts[$productsEntity->book_id]) and $orderProducts[$productsEntity->book_id] > 0) {
				$product['count'] = (int)$orderProducts[$productsEntity->book_id];
			}
			return $product;
		});
		return [
			'id'        => $this->order_id,
			'address'   => ($address instanceof UserAddressesEntity ? $address->apiFormat() : null),
			'products'  => $products,
			'fee'       => $this->fee,
			'total'     => $this->total,
			'discount'  => $this->discount,
			'payable'   => $this->payable,
			'createdAt' => strtotime($this->created_at),
			'status'    => $this->getStatus(),
		];
	}

	public function apiFormat(): array {
		$address = UserAddresses::get($this->user_address_id);
		return [
			'id'        => $this->order_id,
			'address'   => ($address instanceof UserAddressesEntity ? $address->apiFormat() : null),
			'products'  => [],
			'fee'       => $this->fee,
			'total'     => $this->total,
			'discount'  => $this->discount,
			'payable'   => $this->payable,
			'createdAt' => strtotime($this->created_at),
			'status'    => $this->getStatus(),
		];
	}

	public function getStatus(): array {
		$text = "process";
		$info = "";
		switch ($this->status) {
			case 0:
				$text = "در حال پردازش";
				$info = "سفارش شما ثبت شده و در حال پردازش است.";
				break;
			case 1:
				$text = "تایید شده";
				$info = "سفارش شما تایید شد و در حال آماده سازی برای ارسال است.";
				break;
			case 2:
				$text = "ارسال شده";
				$info = "سفارش شما ارسال شد و طی 2 الی 5 روز کاری بدستتان خواهد رسید.";
				break;
			case 3:
				$text = "تحویل داده شده";
				$info = "سفارش شما به آدرس انتخاب شده تحویل داده شد.";
				break;
			case 4:
				$text = "مرجوعی";
				$info = "سفارش شما مرجوع شد.";
				break;
			case -1:
				$text = "لغو شده";
				$info = "سفارش شما لغو شد.";
				break;
		}
		return [
			'id'   => (int)$this->status,
			'text' => $text,
			'info' => $info,
		];
	}

	protected function dictionary(): array {
		return [
			'order_id'        => 'order_id',
			'user_id'         => 'user_id',
			'user_address_id' => 'user_address_id',
			'book_id'         => 'book_id',
			'fee'             => 'order_fee',
			'total'           => 'order_total',
			'discount'        => 'order_discount',
			'payable'         => 'order_payable',
			'status'          => 'order_status',
			'created_at'      => 'created_at',
		];
	}

}
