<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Comments;
use model\Labels;

class BooksEntity extends EntityScheme {
	public $book_id;
	/**
	 * نام
	 **/
	public $name;
	/**
	 * کاور
	 **/
	public $cover;
	/**
	 * قیمت
	 **/
	public $price;
	/**
	 * تاریخ انتشار
	 **/
	public $publish_date;
	/**
	 * خلاصه داستان
	 **/
	public $summary;
	/**
	 * انتخاب برچسب ها
	 **/
	public $label_ids;
	/**
	 * تعداد صفحات
	 **/
	public $pages_number;

	public function model() {
		return new \model\Books();
	}

	public function apiFormat($isBookmarked = false) {
		$labels = Labels::Db()->whereIn('label_id', json_decode($this->label_ids, true) ?? [])->get()->map(function (LabelsEntity $label) {
			return $label->apiFormat();
		})->values();


		$comments = Comments::Db()->where('book_id', $this->book_id)->where('status', 1)->get()->map(function (CommentsEntity $commentsEntity) {
			return $commentsEntity->apiFormat();
		})->values();
		$rating = collect($comments->all())->map(function ($comment) {
			return $comment['rate'];
		})->average();


		return [
			'id'           => $this->book_id,
			'name'         => $this->name,
			'cover'        => $this->cover ? __IMAGES__ . "Books/" . $this->cover : null,
			'price'        => (int)$this->price,
			'publishDate'  => (int)$this->publish_date,
			'summary'      => $this->summary,
			'labels'       => $labels,
			'pageCount'    => (int)$this->pages_number,
			'comments'     => $comments,
			'rating'       => $rating,
			'isAvailable'  => true,
			'isBookmarked' => $isBookmarked,
		];
	}

	protected function dictionary(): array {
		return [
			'book_id'      => 'book_id',
			'name'         => 'book_name',
			'cover'        => 'book_cover',
			'price'        => 'book_price',
			'publish_date' => 'book_publish_date',
			'summary'      => 'book_summary',
			'label_ids'    => 'label_ids',
			'pages_number' => 'book_pages_number',
		];
	}
}
