<?php

namespace site\helpers;

use fwJson\Json;
use model\Entity\MembershipsEntity;
use model\Entity\UsersEntity;
use model\Memberships;
use model\Transactions;
use model\Users;
use payment\BasePayment;

class ZiinaPayment extends BasePayment {
	const Token = 'kncmFWQFQtRuYKI7Sil0GDidTKcYIPg85MJefgbLnIkIdBalzdALBLH9SEx85Cz3';
	const Action_url = 'https://api-v2.ziina.com/api/payment_intent';
	const SuccessCallBack_url = 'https://api.omigra.lexaplus.com/callback/success';
	const CancelCallBack_url = 'https://api.omigra.lexaplus.com/callback/fail';
	const Confirm_url = 'https://api-v2.ziina.com/api/payment_intent/';

	protected $OrderData;

	public function OrderData(Json $json) {
		$this->OrderData = $json;
	}

	public function goToPayment($currency = "AED") {
		$this->CreateResNum();
		$user_data = $this->UserModel->get($this->UserData->{$this->UserModel->_key});
		$id = $this->PaymentModel->save($user_data->{$this->UserModel->_key}, $this->_amount, $this->ResNum, $this->OrderData, $this->type);
		if ($id > 0) {
			$result = CallAPI('post', self::Action_url, [
				'amount'        => $this->_amount,
				'currency_code' => $currency,
				'message'       => 'Thanks for paying',
				'success_url'   => self::SuccessCallBack_url,
				'cancel_url'    => self::CancelCallBack_url,
				'test'          => true
			], [
				"Content-type"  => "application/json",
				"accept"        => "application/json",
				'Authorization' => 'Bearer '.self::Token
			], true);
			$result = json_decode($result, true);

			if (is_string($result['id'])) {
				$this->PaymentModel::edit($id, [
					$this->PaymentModel->ResNumField() => $result['id'],
				]);
				return $result['id'];
			}
			return $result;
		}
		return "fail";
	}

	public function update($resnum, $refnum): bool {
		$resField = $this->PaymentModel->ResNumField();
		$refField = $this->PaymentModel->RefNumField();
		$paymentData = $this->PaymentModel::Db()->where($resField, $resnum)->get()->first;
		$data = json_decode($paymentData->payment_data);
		$user = Users::get($paymentData->user_id);
		if ($user instanceof UsersEntity) {
			$user->credit += $paymentData->payment_amount / 10;
			Transactions::create('افزایش اعتبار', $user->user_id, $paymentData->payment_amount / 10, 1);
			$user->save();
		}
		return $this->PaymentModel::Db()->where($resField, $resnum)->update([
			$refField        => $refnum,
			'payment_status' => 1,
		]);
	}

	public function getResult($Authority): array {
		$PaymentData = $this->PaymentModel::getOneFiltered($this->PaymentModel->ResNumField(), $Authority);
		$data = [
			"merchant_id" => \site\helpers\ZarinPalPayment::MerchantCode,
			"authority"   => $Authority,
			"amount"      => $PaymentData->payment_amount,
		];
		$jsonData = json_encode($data);
		$ch = curl_init(self::Confirm_url);
		curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v4');
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
		curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
			'Content-Type: application/json',
			'Content-Length: ' . strlen($jsonData),
		]);
		$result = curl_exec($ch);
		curl_close($ch);
		return [
			$PaymentData,
			json_decode($result, true)
		];
	}

	public function getIntent($id) {
		return CallAPI('GET', self::Confirm_url . "$id", false, [
			"accept"        => "application/json",
			'Authorization' => 'Bearer '.self::Token
		]);
	}

}
