<?php

namespace middlewares;

use Api\BaseRouter;
use FwRoutingSystem\Middleware;
use FwRoutingSystem\Router;

class  RouterMiddleware implements Middleware {
    public $mainRouter;
    public $router;

    public function __construct(BaseRouter $mainRouter, Router $router) {
        $this->mainRouter = $mainRouter;
        $this->router = $router;
    }

    public function handle() {
        if (sizeof($this->mainRouter->requiredHeaders()) > 0) {
            foreach ($this->mainRouter->requiredHeaders() as $header => $validator) {
                $value = get_header($header);
                if (!$value) {
                    $value = $_REQUEST['auth'];
                }
                if (!$value) {
                    $data = json_decode(file_get_contents('php://input') ?? '', true);
                    if ($data){
                        $value = $data['auth'];
                    }
                }
                if (!$value) {
                    echo response(['message' => "$header must be sent as a header"], 400);
                    $this->router->outputSent = true;
                    exit();
                } else {
                    $validatorResult = $validator($value);
                    if ($validatorResult['isCustom'] === false) {
                        if ($validatorResult['validate'] === false) {
                            echo response(['message' => "$header is not valid"], 400);
                            $this->router->outputSent = true;
                            exit();
                        }
                    } else {
                        if ($validatorResult['validate'] === false) {
                            echo response($validatorResult['message'], $validatorResult['statusCode']);
                            $this->router->outputSent = true;
                            exit();
                        }
                    }

                    $this->mainRouter->routes($this->router);
                }
            }
        } else {
            $this->mainRouter->routes($this->router);
        }
    }
}
