<?php

namespace Api;

use FwRoutingSystem\Router;
use middlewares\RouterMiddleware;
use model\Entity\UsersEntity;
use model\Users;

abstract class BaseRouter {
    public $groupPath;

    abstract public function routes(Router $router);

    abstract public function requiredHeaders(): array;

    final public function getParam(string $key, bool $isRequired = true, callable $validator = NULL, array $errorMessage = NULL) {
        $data = json_decode(file_get_contents('php://input'), true);
        if ($isRequired) {
            if (isset($_POST[$key])) {
                if (is_callable($validator)) {
                    if (!$validator($_POST[$key])) {
                        if (!$errorMessage) $errorMessage = ['message' => "$key is not valid"];
                        echo response($errorMessage, 400);
                        die();
                    }
                }
            } elseif (isset($data[$key])) {
                if (is_callable($validator)) {
                    if (!$validator($data[$key])) {
                        if (!$errorMessage) $errorMessage = ['message' => "$key is not valid"];
                        echo response($errorMessage, 400);
                        die();
                    }
                }
            } else {
                $errorMessage = ['message' => "$key is required"];
                echo response($errorMessage, 400);
                die();
            }
        } else {
            if (isset($_POST[$key])) {
                if (is_callable($validator)) {
                    if (!$validator($_POST[$key])) {
                        if (!$errorMessage) $errorMessage = ['message' => "$key is not valid"];
                        echo response($errorMessage, 400);
                        die();
                    }
                }
            } elseif (isset($data[$key])) {
                if (is_callable($validator)) {
                    if (!$validator($data[$key])) {
                        if (!$errorMessage) $errorMessage = ['message' => "$key is not valid"];
                        echo response($errorMessage, 400);
                        die();
                    }
                }
            }
        }
        if (isset($_POST[$key])) {
            return is_array($_POST[$key]) ? $_POST[$key] : trim($_POST[$key]);
        }
        return is_array($data[$key]) ? $data[$key] : trim($data[$key]);
    }

    protected function auth(): array {
        return [
            'auth' => function ($token) {
                return [
                    'isCustom'   => true,
                    'validate'   => Users::findToken($token) instanceof UsersEntity,
                    'statusCode' => 403,
                    'message'    => [
                        'message' => 'client not found',
                        'hint'    => 'you can obtain a new token by using the {obtainToken} endpoint',
                    ],
                ];
            },
        ];
    }

    final protected function middleware(Router $router): array {
        return [
            'before' => new RouterMiddleware($this, $router),
        ];
    }
}
