<?php

namespace controller;

use ControllerScheme;
use model\Entity\UsersEntity;

class Users extends ControllerScheme {
    const name = 'کاربر';

    public static $__uploads = ["user_avatar" => __SOURCE__ . "images/Users/"];

    protected function add(?bool $csrf = true)
    {
        $this->changeRequestValue('token',md5(time()));
        return parent::add($csrf); // TODO: Change the autogenerated stub
    }

    public function sendTest() {
        $userId = $this->requestArray('userId');
        $user = \model\Users::get($userId);
        if ($user instanceof UsersEntity) {
            return sendPushNotification($user->firebase_token, "New Message", json_encode([
                'type'    => 'test',
                'content' => 'hi',
            ]));
        }
    }
	public function toggleBlock() {
		$userId = $this->requestArray('userId');
		$status = $this->requestArray('status');
		if (\model\Users::edit($userId, [
			'is_locked' => $status == 'block' ? 1 : 0,
		])) {
			return 'ok';
		}
		return 'fail';
	}
    public function sensSMS()
    {
        $mobile = $this->requestArray()['mobile'];
        $text = $this->requestArray()['text'];
        $sms = sendVerify($mobile,[$text]);
        if ($sms){
            return '1';
        }else{
            return '2';
        }

    }
}