<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Attrs\Style\Props\Target;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use View;

class Users extends View {

	public $SingularName = 'کاربر';
	public $PluralName = 'کاربران';

	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refresh()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
//                                                                    HtmlTags::Th('نام کامل'),
																	HtmlTags::Th('نام کاربری'),
																	HtmlTags::Th('شماره همراه'),
																	HtmlTags::Th('تاریخ ثبت نام'),
//                                                                    HtmlTags::Th('کیف پول'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150'),
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																		'user_email',
																		'mobile',
																		'created_at',
																], false, true, false, true, function ($row) {
																	if ($row->is_locked == 1) {
																		return HtmlTags::A('.btn.btn-success.p-2.toggleBlock')->Content(
																			HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Unlock())
																		)->Data_('status', 'unlock')
																			->Data_('id', $row->user_id)
																			->Data_('toggle', 'tooltip')
																			->Data_('placement', 'top')
																			->Target(Target::_Blank())
																			->Title('آنبلاک');
																	} else {
																		return HtmlTags::A('.btn.btn-danger.p-2.toggleBlock')->Content(
																			HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Ban())
																		)->Data_('status', 'block')
																			->Data_('id', $row->user_id)
																			->Data_('toggle', 'tooltip')
																			->Data_('placement', 'top')
																			->Title('بلاک');
																	}
																})
															)
													)
											)
									)
							)
						)
				);
	}

	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}

	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .

										HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات هویتی ') .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('نام') .
										$this->Html()->Input('user_name') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('شماره موبایل') .
										$this->Html()->Mobile('mobile') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('ایمیل') .
										$this->Html()->Email('user_email') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('تاریخ تولد') .
										$this->Html()->Date('birthdate') .
										$this->Html()->FormGroupEnd() .


										HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات تکمیلی ') .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('انتخاب کشور') .
										$this->Html()->Select('country_id', 'country_id', \model\Countries::toOption()) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('انتخاب استان') .
										$this->Html()->Select('state_id', 'state_id', \model\States::toOption()) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('انتخاب شهر') .
										$this->Html()->Select('city_id', 'city_id', \model\Cities::toOption()) .
										$this->Html()->FormGroupEnd() .
//                                        $this->Html()->FormGroupStart(12) .
//                                        $this->Html()->Label('دسته بندی های مورد علاقه') .
//                                        $this->Html()->Select('user_categories[]', 'user_categories',\model\Categories::toOption(),true,false) .
//                                        $this->Html()->FormGroupEnd() .


//                                        $this->Html()->FormGroupStart() .
//                                        $this->Html()->Label('رشته تحصیلی') .
//                                        $this->Html()->Input('user_study_field','user_study_field','',false) .
//                                        $this->Html()->FormGroupEnd() .
//                                        $this->Html()->FormGroupStart() .
//                                        $this->Html()->Label('مقطع تحصیلی') .
//                                        $this->Html()->Input('user_study_degree','user_study_degree','',false) .
//                                        $this->Html()->FormGroupEnd() .


										HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات حساب کاربری ') .
										$this->Html()->FormGroupStart() .
										$this->Html()->Label('جنسیت') .
										$this->Html()->Input('user_gender','user_gender','',false) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('رمز عبور') .
										$this->Html()->Password('user_password') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('تصویر پروفایل (اختیاری)') .
										($this->State() == "add" ? $this->Html()->ImageInput('user_avatar', 'image/*', '150', '150', 'true', 'user_picture', false) : HtmlTags::Img()->Attrs(['style' => 'width: 50px;height: 50px'])->Src(is_file(__SOURCE__ . 'images/Users/' . $this->getData()->user_id . '.jpg') ? __IMAGES__ . '/Users/' . $this->getData()->user_id . '.jpg' : __IMAGES__ . '/Users/placeholder.jpg')),
										$this->Html()->FormGroupEnd() .

//                                        $this->Html()->FormGroupStart(4) .
//                                        $this->Html()->Label('کیف پول') .
//                                        $this->Html()->Price('user_credit') .
//                                        $this->Html()->FormGroupEnd() .


										$this->Html()->CardFooter()
									)
							)
						)
				);
	}

	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}

	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

}
