<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;
use model\Ads;
use model\Cities;
use model\Countries;
use model\Jobs;
use model\States;

class UsersEntity extends EntityScheme
{
    public $user_id;
    public $name;
    public $mobile;
    public $membership_id;
    public $image;
    public $last_notif_seen_date;
    public $password;
    public $login_date;
    public $firebase_token;
    public $token;

    public function model(): \model\Users
    {
        return new \model\Users();
    }

    public function apiFormat(): array
    {
        $membership = \model\Memberships::get($this->membership_id);
        return [
            'id' => $this->user_id,
            'name' => $this->name . '',
            'mobile' => $this->mobile ?? "",
            'image' => is_file(__SOURCE__ . 'images/Users/' . $this->user_id . '.jpg') ? __IMAGES__ . 'Users/' . $this->user_id . '.jpg' : __IMAGES__ . 'Users/placeholder.jpg',
            'membership' => $membership instanceof MembershipsEntity ? $membership->apiFormat() : ""
        ];
    }

    public function toOption(): Option
    {
        return HtmlTags::Option()->Value($this->user_id)->Content($this->name . ' - ' . $this->mobile);
    }

    public function commentFormat(): array
    {
        return [
            'id' => $this->user_id,
            'avatar' => $this->image(),
            'name' => $this->name,
        ];
    }

    public function image(): string
    {
        return is_file(__SOURCE__ . 'images/Users/' . $this->user_id . '.jpg') ? __IMAGES__ . '/Users/' . $this->user_id . '.jpg' : __IMAGES__ . '/Users/placeholder.jpg';
    }

    protected function dictionary(): array
    {
        return [
            'user_id' => 'user_id',
            'name' => 'user_name',
            'password' => "user_password"

        ];
    }
}
