<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Episodes;
use model\Labels;

class StoriesEntity extends EntityScheme {
	public $story_id;
	/**
	 * نام داستان
	 **/
	public $name;
	/**
	 * کاور
	 **/
	public $cover;
	/**
	 * برچسب ها
	 **/
	public $label_ids;
	/**
	 * تاریخ شروع داستان
	 **/
	public $start_date;
	/**
	 * وضعیت داستان
	 **/
	public $is_ended;
	/**
	 * انتخاب پلن
	 **/
	public $plan_id;

	public function model() {
		return new \model\Stories();
	}

	public function singleApiFormat($isBookmarked = false): array {
		$labels = Labels::Db()->whereIn('label_id', json_decode($this->label_ids, true) ?? [])->get()->map(function (LabelsEntity $label) {
			return $label->apiFormat();
		})->values();
		return [
			'id'           => $this->story_id,
			'name'         => $this->name,
			'cover'        => $this->cover ? __IMAGES__ . "Stories/" . $this->cover : null,
			'labels'       => $labels,
			'startDate'    => (int)$this->start_date,
			'isEnded'      => $this->is_ended == 1,
			'lastEpisode'  => null,
			'comingNumber' => 0,
			'episodes'     => Episodes::Db()->where('story_id', $this->story_id)->orderBy('episode_number', true)->get()->map(function (EpisodesEntity $episodesEntity) {
				return $episodesEntity->apiFormat();
			})->values(),
			'isBookmarked' => $isBookmarked,
		];
	}

	public function apiFormat(?EpisodesEntity $lastEpisode = null, $isBookmarked = false): array {
		$labels = Labels::Db()->whereIn('label_id', json_decode($this->label_ids, true) ?? [])->get()->map(function (LabelsEntity $label) {
			return $label->apiFormat();
		})->values();
		return [
			'id'           => $this->story_id,
			'name'         => $this->name,
			'cover'        => $this->cover ? __IMAGES__ . "Stories/" . $this->cover : null,
			'labels'       => $labels,
			'startDate'    => (int)$this->start_date,
			'isEnded'      => $this->is_ended == 1,
			'lastEpisode'  => $lastEpisode instanceof EpisodesEntity ? $lastEpisode->apiFormat() : null,
			'comingNumber' => (int)($lastEpisode instanceof EpisodesEntity ? $lastEpisode->number : Episodes::Db()->where('story_id', $this->story_id)->orderBy('episode_number', true)->limit(1)->get()->first->episode_number ?? 0),
			'episodes'     => [],
			'isBookmarked' => $isBookmarked,
		];
	}

	protected function dictionary(): array {
		return [
			'story_id'   => 'story_id',
			'name'       => 'story_name',
			'cover'      => 'story_cover',
			'label_ids'  => 'label_ids',
			'start_date' => 'story_start_date',
			'is_ended'   => 'is_ended',
			'plan_id'    => 'plan_id',
		];
	}
}
