<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Files;

class MembershipsEntity extends EntityScheme {
	public $membership_id;
	public $name;
	public $icon_id;
	public $price;
	public $benefits;
	public $details;

	public function model() {
		return new \model\Memberships();
	}

	public function apiFormat(): array {
        $icon = Files::get($this->icon_id!=0??1);
		return [
			'id'       => $this->membership_id,
			'name'     => $this->name,
			'icon'     => $icon instanceof FilesEntity ? $icon->apiFormat() : null,
			'price'    => $this->price,
			'details'  => $this->details . '',
			'benefits' => json_decode($this->benefits),
		];
	}

	protected function dictionary(): array {
		return [
			'membership_id' => 'membership_id',
			'name'          => 'membership_name',
			'icon_id'       => 'icon_id',
			'price'         => 'membership_price',
			'benefits'      => 'membership_benefits',
			'details'       => 'membership_details',
		];
	}
}
