<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;

class EpisodesEntity extends EntityScheme {
	public $episode_id;
	/**
	 * انتخاب داستان
	 **/
	public $story_id;
	/**
	 * اپیزود چندم ؟
	 **/
	public $number;
	/**
	 * محتوای اپیزود
	 **/
	public $content;
	public $date;

	public function model() {
		return new \model\Episodes();
	}

	public function toOption(): Option {
		return HtmlTags::Option()->Value($this->episode_id)->Content($this->number);
	}

	public function apiFormat(): array {
		return [
			'id'      => (int)$this->episode_id,
			'number'  => (int)$this->number,
			'content' => $this->content . '',
			'date'    => (int)$this->date,
		];
	}

	protected function dictionary(): array {
		return [
			'episode_id' => 'episode_id',
			'story_id'   => 'story_id',
			'number'     => 'episode_number',
			'content'    => 'episode_content',
			'date'       => 'episode_date',
		];
	}
}
