<?php

namespace FwCharge;

use payment\BasePayment;
use PayingUserInterface;
use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;

class ChargeClass {
	const userName = 'negarinehuser';
	const password = 'n3G@r1Neh';
	const webServiceUrl = 'https://echarge.mobtakerancell.com/TopUp/ChargeSrv.svc?singleWsdl';
	const buyChargePayType = 'buy_charge';
	const buyPackagePayType = 'buy_package';
	/**
	 * @var BasePayment
	 */
	private $paymentClass;
	/**
	 * @var PayingUserInterface
	 */
	private $userModel;
	
	public static function Update($resNum, string $string) {
		return (new Db('ChargesTable'))->where('charge_resnum', $resNum)->update([
			'is_successful' => $string,
		]);
	}
	public static function UpdateInternetPackage($resNum, string $string) {
		return (new Db('InternetPackagesTable'))->where('internet_package_resnum', $resNum)->update([
			'is_successful' => $string,
		]);
	}
	
	public function setPaymentClass(BasePayment $paymentClass) {
		$this->paymentClass = $paymentClass;
	}
	
	public function reserve(BasePayment $payment, $operatorId) {
		$client = new \nusoap_client($this::webServiceUrl);
		$client->soap_defencoding = 'UTF-8';
		$result = $client->call('ReserveCharge', [
			[
				'requestData' => [
//				'Username'      => self::userName,
//				'Password'      => self::password,
'ReserveNumber' => (int)$payment->ResNum,
'TotalAmount'   => $payment->_amount,
'ChargeType'    => 0,
'DeviceType'    => 59,
'LocalDateTime' => date('Y/m/dTH:i:s'),
'BankId'        => (int)$payment->chargeServiceBankId,
'TerminalId'    => 98594525,
'OperatorId'    => (int)$operatorId,
				],
			],
		]);
		return $result;
	}
	
	public function setUserModel(PayingUserInterface $paying_userModel) {
		$this->userModel = $paying_userModel;
		$this->paymentClass->UserModel($paying_userModel, NULL);
	}
	
	public function sendFields() {
		return [
			'ReserveNumber',
			'TotalAmount',
			'ChargeType',
			'DeviceType',
			'BankId',
			'OperatorId',
		];
	}
	
	public function save(int $customer_id, $payment_id, string $resNum, int $total_amount, $mobile, string $callback) {
		$Db = new Db('ChargesTable');
		return $Db->insertWithId([
				'payment_id'    => $payment_id,
				'charge_resnum' => $resNum,
				'amount'        => $total_amount,
				'mobile'        => $mobile,
				'callback'      => $callback,
			]) > 0;
	}
	
	public function savePackage(int $customer_id, $payment_id, $packageCode, $packageCost, string $resNum, int $total_amount, $mobile, string $callback) {
		$Db = new Db('InternetPackagesTable');
		return $Db->insertWithId([
				'payment_id'              => $payment_id,
				'internet_package_resnum' => $resNum,
				'package_code'            => $packageCode,
				'package_cost'             => $packageCost,
				'amount'                  => $total_amount,
				'mobile'                  => $mobile,
				'callback'                => $callback,
			]) > 0;
	}
}
